#include "GLOBAL.H"

//----- TIMER0.C -----//
extern BYTE T0Cnt;                               // Timer0 Count

void Initial_IAP(void)
{ CKCON1 = 11;                                   // IHRCO = 12.0Mhz
}


void IAP_Erase(BYTE AddrH, BYTE Page_Cnt )
{ while( Page_Cnt )
  { T0Cnt = 0;                                   // clear Over Time
    IFADRH = AddrH;
    IFADRL = 0x00;
    IFMT = 0x03;							                   // erase
    ISPCR = ISP_ENABLE;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
    Page_Cnt--;
    AddrH += 2;                                  // For next PAGE, 512 bytes
  }
}


void IAP_Program(BYTE AddrH, BYTE AddrL, BYTE Dta)
{ IFADRH = AddrH;
  IFADRL = AddrL;
  IFD = Dta;
  IFMT = 0x02;								                   // program
  ISPCR = ISP_ENABLE;
  SCMD = 0x46;
  SCMD = 0xB9;
  ISPCR = ISP_DISABLE;
}


BYTE IAP_Read(BYTE AddrH, BYTE AddrL)
{ BYTE Dta;

  IFADRH = AddrH;
  IFADRL = AddrL;
  IFMT = 0x01;								                   // read
  ISPCR = ISP_ENABLE;
  SCMD = 0x46;
  SCMD = 0xB9;
  ISPCR = ISP_DISABLE;

  Dta = IFD;
  return Dta;
}

